Attribute VB_Name = "mdRotateObjects"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to Rotate given objectset

Sub RotateObjects(angle As Double, lineSet As ObjectSet)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Rem To formulate the rotation matrix
Pi = 3.14159265359

theta = angle * Pi / 180
cosine = Cos(theta)
sine = Sin(theta)

Dim localX As zDirection
Set localX = wp.GetLocalX

Dim localY As zDirection
Set localY = wp.GetLocalY

Dim newX As zVector
Set newX = localX.Multiply(cosine).Add(localY.Multiply(sine))

Dim newY As zVector
Set newY = localX.Multiply(-sine).Add(localY.Multiply(cosine))

Dim oldmap As zMatrix
Set oldmap = app.GetClass("Matrix").CreateTranslationMatrix(wp.GetLocalOrigin).MultiplyByMatrix(app.GetClass("Matrix").CreateRotationMatrix(localX, localY))

Dim newmap As zMatrix
Set newmap = app.GetClass("Matrix").CreateTranslationMatrix(wp.GetLocalOrigin).MultiplyByMatrix(app.GetClass("Matrix").CreateRotationMatrix(newX.GetDirection, newY.GetDirection))

Rem rotmat is the rotation matrix
Dim rotmat As zMatrix
Set rotmat = newmap.MultiplyByMatrix(oldmap.GetInverse)

Rem Perform the transformation on the object set
wp.TransformObjects lineSet, rotmat


End Sub

